import { dbRun, dbAll } from '../config/database.js';

async function initializeAllRates() {
  try {
    // Check current rates
    const existingRates = await dbAll('SELECT currency_pair FROM exchange_rates');
    const existingPairs = new Set(existingRates.map(r => r.currency_pair));
    
    console.log('Existing pairs:', Array.from(existingPairs));
    
    // Define all required currency pairs with default rates
    const requiredPairs = [
      { pair: 'ZAR-NGN', buy: 22.5, sell: 23 },
      { pair: 'NGN-ZAR', buy: 0.043, sell: 0.044 },
      { pair: 'ZAR-USDT', buy: 0.055, sell: 0.056 },
      { pair: 'USDT-ZAR', buy: 17.5, sell: 18 },
      { pair: 'NGN-USDT', buy: 0.0012, sell: 0.0013 },
      { pair: 'USDT-NGN', buy: 750, sell: 770 }
    ];
    
    // Insert missing pairs
    for (const { pair, buy, sell } of requiredPairs) {
      if (!existingPairs.has(pair)) {
        console.log(`Adding ${pair} with buy=${buy}, sell=${sell}`);
        await dbRun(
          `INSERT INTO exchange_rates (currency_pair, buy_rate, sell_rate) VALUES (?, ?, ?)`,
          [pair, buy, sell]
        );
      }
    }
    
    // Display all rates
    const allRates = await dbAll('SELECT * FROM exchange_rates');
    console.log('\nAll rates:');
    console.log(JSON.stringify(allRates, null, 2));
  } catch (error) {
    console.error('Error:', error);
  }
  process.exit(0);
}

initializeAllRates();
