#!/bin/bash

# Production Deployment Script for ZAR-Naira Exchange

echo "🚀 Starting ZAR-Naira Exchange Production Deployment"
echo "=================================================="

# Check if .env file exists
if [ ! -f ".env" ]; then
    echo "❌ Error: .env file not found!"
    echo "Please copy .env.production to .env and configure your settings"
    exit 1
fi

# Check if JWT_SECRET is set
if grep -q "your-super-secure-jwt-secret-key-here-change-this-in-production" .env; then
    echo "❌ Error: JWT_SECRET is still default!"
    echo "Please change JWT_SECRET in .env file to a secure random key"
    exit 1
fi

# Initialize database if needed
echo "📊 Initializing database..."
npm run init-db:prod

# Start the production server
echo "🌐 Starting production server..."
echo "✅ Security features enabled:"
echo "   - Admin credentials hidden from logs"
echo "   - Error details sanitized"
echo "   - Request logging disabled"
echo "   - Database paths hidden"
echo ""
echo "⚠️  REMEMBER: Change admin password after first login!"
echo ""

npm run start:prod