# Production Deployment Script for ZAR-Naira Exchange (Windows)

Write-Host "🚀 Starting ZAR-Naira Exchange Production Deployment" -ForegroundColor Green
Write-Host "==================================================" -ForegroundColor Green

# Check if .env file exists
if (-Not (Test-Path ".env")) {
    Write-Host "❌ Error: .env file not found!" -ForegroundColor Red
    Write-Host "Please copy .env.production to .env and configure your settings" -ForegroundColor Yellow
    exit 1
}

# Check if JWT_SECRET is set to default
$envContent = Get-Content ".env" -Raw
if ($envContent -match "your-super-secure-jwt-secret-key-here-change-this-in-production") {
    Write-Host "❌ Error: JWT_SECRET is still default!" -ForegroundColor Red
    Write-Host "Please change JWT_SECRET in .env file to a secure random key" -ForegroundColor Yellow
    Write-Host "You can generate one using: node -e ""console.log(require('crypto').randomBytes(64).toString('hex'))""" -ForegroundColor Cyan
    exit 1
}

# Initialize database if needed
Write-Host "📊 Initializing database..." -ForegroundColor Blue
npm run init-db:prod

# Start the production server
Write-Host "🌐 Starting production server..." -ForegroundColor Blue
Write-Host "✅ Security features enabled:" -ForegroundColor Green
Write-Host "   - Admin credentials hidden from logs" -ForegroundColor White
Write-Host "   - Error details sanitized" -ForegroundColor White
Write-Host "   - Request logging disabled" -ForegroundColor White
Write-Host "   - Database paths hidden" -ForegroundColor White
Write-Host ""
Write-Host "⚠️  REMEMBER: Change admin password after first login!" -ForegroundColor Yellow
Write-Host ""

npm run start:prod