# 🚀 Quick Start Guide

## Backend is Ready!

Your Node.js backend with LowDB JSON database is fully set up and running!

## ⚡ Quick Commands

### Start Server
```bash
cd backend
node server.js
```

### Initialize Database (Already Done!)
```bash
npm run init-db
```

### Development Mode (Auto-restart on changes)
```bash
npm run dev
```

## 🔑 Admin Credentials

**Username:** `admin`  
**Password:** `admin123`

## 🌐 API Base URL

**Local:** http://localhost:3000

## 📋 Test Endpoints

### 1. Health Check
```bash
curl http://localhost:3000/api/health
```

### 2. Login
```bash
curl -X POST http://localhost:3000/api/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username":"admin","password":"admin123"}'
```

### 3. Change Password (after login)
```bash
curl -X POST http://localhost:3000/api/auth/change-password \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -d '{
    "currentPassword":"admin123",
    "newPassword":"NewPassword123",
    "confirmPassword":"NewPassword123"
  }'
```

## 📁 Important Files

- **Server:** `server.js`
- **Database:** `database/exchange.db`
- **Config:** `.env`
- **API Docs:** `README.md`
- **Test Guide:** `TEST_GUIDE.md`
- **Postman Collection:** `postman_collection.json`

## ✅ What's Working

- ✅ LowDB JSON database with all tables
- ✅ Admin user created
- ✅ JWT authentication
- ✅ Login/logout
- ✅ **Password change feature**
- ✅ Exchange requests
- ✅ Exchange rates
- ✅ Protected admin routes

## 🎯 Next Steps

1. **Test the API** using Postman collection
2. **Change admin password** for security
3. **Connect frontend** to the backend
4. **Customize** exchange rates for your needs

## 📚 More Info

- See `SETUP_COMPLETE.md` for detailed information
- See `README.md` for full API documentation
- See `TEST_GUIDE.md` for testing examples

---

**Current Status:** ✅ Server Running on http://localhost:3000

Need help? Check the documentation files listed above!
